/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "mx_auto_config.h"
#include "myriexpress.h"
#if !MX_OS_WINNT
#include <unistd.h>
#else
#include "mx_uni.h"
#endif
#include "test_common.h"

int
main(void)
{
  mx_return_t ret;
  mx_endpoint_t ep;
  mx_endpoint_addr_t addr;
  mx_request_t recv_req;
  mx_request_t send_req;
  mx_segment_t recv_seg;
  mx_segment_t send_seg;
  mx_status_t status;
  char recv_buff[80];
  char send_buff[80];
  uint32_t result;

  ret = mx_init();
  insist(ret == MX_SUCCESS);

  ret = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, 0, NULL, 0, &ep);
  insist(ret == MX_SUCCESS);

  ret = mx_get_endpoint_addr(ep, &addr);
  insist(ret == MX_SUCCESS);


  send_seg.segment_ptr = send_buff;
  send_seg.segment_length = 80;
  ret = mx_isend(ep, &send_seg, 1, addr, 0, NULL, &send_req);
  insist(ret == MX_SUCCESS);

  ret = mx_ibuffered(ep, &send_req, &result);
  insist((ret == MX_SUCCESS) && (result == 1));

  ret = mx_test(ep, &send_req, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));

  recv_seg.segment_ptr = recv_buff;
  recv_seg.segment_length = 80;
  ret = mx_irecv(ep, &recv_seg, 1, 0, 0, NULL, &recv_req);
  insist(ret == MX_SUCCESS);

  sleep(10);

  ret = mx_test(ep, &recv_req, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));

  ret = mx_close_endpoint(ep);
  insist(ret == MX_SUCCESS);

  ret = mx_finalize();
  insist(ret == MX_SUCCESS);

  return 0;
}
